import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";
import { queryResponse } from "../util/processResponse.js";

const initialState = {
    myTrackOrders: {},
    loading: false,
};

export const getTrackOrders = createAsyncThunk(
    "orders/getTrackOrders",
    async ({ URL }) => {
        const response = await queryResponse(URL);
        return response;
    }
);

const getTrackOrdersSlice = createSlice({
    name: "trackOrders",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(getTrackOrders.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getTrackOrders.fulfilled, (state, { payload }) => {
            state.loading = false;
            state.myTrackOrders = payload;
        });
        builder.addCase(getTrackOrders.rejected, (state) => {
            state.loading = false;
        });
    },
});

export default getTrackOrdersSlice.reducer;
